#ifndef __IThreadListener__
#define __IThreadListener__

#include "../Basics/CCountedObject.hpp"
using Exponent::Basics::CCountedObject;

//	===========================================================================

namespace Exponent
{
	namespace Threading
	{
		/** @cond */
		interface IThread;
		/** @endcond */

		/**
		 * @interface IThreadListener IThreadListener.hpp
		 * @brief A listener to threading information
		 *
		 * @date 13/01/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: IThreadListener.hpp,v 1.5 2007/02/08 21:06:44 paul Exp $
		 */
		interface IThreadListener
		{
			
//	===========================================================================
			
		public:
			
//	===========================================================================
			
			/**
			 * Construction
			 */
			IThreadListener() { }
			
			/**
			 * Destruction
			 */
			virtual ~IThreadListener() { }
			
//	===========================================================================

			/**
			 * Thread has completed
			 * @param thread The thread that completed
			 */
			virtual void threadHasCompleted(IThread *thread) = 0;
			
			/**
			 * Thread has crashed / failed in some way
			 * @param thread The thread that failed
			 */
			virtual void threadHasAborted(IThread *thread) = 0;
		};
	}
}
#endif	// End of IThreadListener.hpp